<?php
session_start();
include "koneksi.php";

// Jika belum login, redirect ke login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Ambil data user login
$username = $_SESSION['username'];
$user_login = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE username='$username'"));

// --- Ambil filter dari GET ---
$angkatan      = $_GET['angkatan']      ?? "";
$fakultas      = $_GET['Fakultas']      ?? "all";
$selectedProdi = $_GET['selectedProdi'] ?? "all";
$jalur_masuk   = $_GET['jalur_masuk']   ?? "";
$provinsi      = $_GET['provinsi']      ?? "";
$kab_or_kota   = $_GET['kab_or_kota']   ?? "";
$jenis_kelamin = $_GET['jenis_kelamin'] ?? "";
$jenjang       = $_GET['jenjang']       ?? "all"; // 🔹 filter jenjang

// --- Query Filter Dropdown ---
$angkatanRes = mysqli_query($conn, "SELECT DISTINCT angkatan FROM mahasiswa ORDER BY angkatan DESC");
$fakultasRes = mysqli_query($conn, "SELECT nama_fakultas FROM fakultas ORDER BY nama_fakultas ASC");
$jalurRes    = mysqli_query($conn, "SELECT nama_jalur FROM jalur_masuk ORDER BY nama_jalur ASC");
$provinsiRes = mysqli_query($conn, "SELECT DISTINCT provinsi FROM mahasiswa ORDER BY provinsi ASC");
$kotaRes     = mysqli_query($conn, "SELECT DISTINCT kab_or_kota FROM mahasiswa ORDER BY kab_or_kota ASC");
$jenjangRes  = mysqli_query($conn, "SELECT id, nama_jenjang FROM jenjang_pendidikan ORDER BY nama_jenjang ASC");

// --- Query Data Mahasiswa ---
$sql = "
    SELECT m.id, m.nim, m.nama_mahasiswa, 
           jp.nama_jenjang,
           f.nama_fakultas, p.nama_prodi, 
           m.angkatan, jm.nama_jalur, 
           m.provinsi, m.kab_or_kota, m.jenis_kelamin
    FROM mahasiswa m
    JOIN jenjang_pendidikan jp ON m.jenjang_id = jp.id
    JOIN fakultas f ON m.fakultas_id = f.id
    JOIN program_studi p ON m.program_studi_id = p.id
    JOIN jalur_masuk jm ON m.jalur_masuk_id = jm.id
    WHERE 1=1
";

// Terapkan filter jika ada
if ($angkatan)      $sql .= " AND m.angkatan = '".mysqli_real_escape_string($conn, $angkatan)."'";
if ($jenjang != "all") $sql .= " AND jp.id = '".mysqli_real_escape_string($conn, $jenjang)."'"; // 🔹 filter jenjang
if ($fakultas != "all") $sql .= " AND f.nama_fakultas = '".mysqli_real_escape_string($conn, $fakultas)."'";
if ($selectedProdi != "all") $sql .= " AND p.nama_prodi = '".mysqli_real_escape_string($conn, $selectedProdi)."'";
if ($jalur_masuk)   $sql .= " AND jm.nama_jalur = '".mysqli_real_escape_string($conn, $jalur_masuk)."'";
if ($provinsi)      $sql .= " AND m.provinsi = '".mysqli_real_escape_string($conn, $provinsi)."'";
if ($kab_or_kota)   $sql .= " AND m.kab_or_kota = '".mysqli_real_escape_string($conn, $kab_or_kota)."'";
if ($jenis_kelamin) $sql .= " AND m.jenis_kelamin = '".mysqli_real_escape_string($conn, $jenis_kelamin)."'";

// --- Pagination ---
$limit = 20; // jumlah data per halaman
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

$offset = ($page - 1) * $limit;

// Hitung total data untuk pagination
$countQuery = mysqli_query($conn, "SELECT COUNT(*) as total FROM ($sql) AS count_table");
$totalData = mysqli_fetch_assoc($countQuery)['total'];
$totalPages = ceil($totalData / $limit);

// Tambahkan limit dan offset ke query utama
$sql .= " ORDER BY m.angkatan DESC, m.nama_mahasiswa ASC LIMIT $limit OFFSET $offset";
$query = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Mahasiswa - SIMABA</title>
    <link rel="icon" type="image/png" href="assets/L-o-g-o_U-P-R_s-t-a-t-u-t-a_2-0-1-7_Per-men-ris-tek-dik-ti42-2-0-1-7_j_t_s-RevOk240x240.png">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 font-sans">
<div class="flex min-h-screen">
<!-- SIDEBAR -->
<aside class="w-64 bg-blue-700 text-white flex flex-col justify-between shadow-lg">
    <div>
        <div class="p-6 border-b border-green-600 flex items-center justify-center gap-3">
            <img src="assets/L-o-g-o_U-P-R_s-t-a-t-u-t-a_2-0-1-7_Per-men-ris-tek-dik-ti42-2-0-1-7_j_t_s-RevOk240x240.png" alt="Logo UPR" class="w-12 h-12 rounded-full">
            <div>
                <h2 class="text-lg font-bold tracking-wide">SIMABA</h2>
                <p class="text-xs text-green-200">Universitas Palangka Raya</p>
            </div>
        </div>
        <nav class="mt-6 px-4">
            <ul class="space-y-2 font-medium">
                <!-- Dashboard -->
                <li>
                    <a href="index.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                    </svg>
                        Dashboard
                    </a>
                </li>
                <!-- Statistik -->
                <li>
                    <a href="statistik.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'statistik.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 0 1 3 19.875v-6.75ZM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V8.625ZM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V4.125Z" />
                    </svg>
                        Statistik
                    </a>
                </li>

                <!-- Data Mahasiswa -->
                <li>
                    <a href="data_mahasiswa.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'data_mahasiswa.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 0 1-1.125-1.125M3.375 19.5h7.5c.621 0 1.125-.504 1.125-1.125m-9.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-7.5A1.125 1.125 0 0 1 12 18.375m9.75-12.75c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125m19.5 0v1.5c0 .621-.504 1.125-1.125 1.125M2.25 5.625v1.5c0 .621.504 1.125 1.125 1.125m0 0h17.25m-17.25 0h7.5c.621 0 1.125.504 1.125 1.125M3.375 8.25c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m17.25-3.75h-7.5c-.621 0-1.125.504-1.125 1.125m8.625-1.125c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M12 10.875v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125M13.125 12h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125M20.625 12c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5M12 14.625v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 14.625c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m0 1.5v-1.5m0 0c0-.621.504-1.125 1.125-1.125m0 0h7.5" />
                    </svg>
                        Data Mahasiswa
                    </a>
                </li>

                <!-- Helpdesk -->
                 <?php if ($user_login['role'] === 'admin'): ?>
                <li>
                    <a href="helpdesk_list.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'helpdesk_list.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126ZM12 15.75h.007v.008H12v-.008Z" />
                    </svg>

                        Helpdesk
                    </a>
                </li>
                <?php endif; ?>

                <!-- Data Pengguna (hanya admin) -->
                <?php if ($user_login['role'] === 'admin'): ?>
                <li>
                    <a href="data_user.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'data_user.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                    </svg>
                        Data Pengguna
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>

<!-- PROFIL PENGGUNA (Sidebar bawah, versi rapi & konsisten) -->
<div class="relative p-4 border-t border-blue-700" x-data="{ open: false }">
    <!-- Tombol nama pengguna -->
    <button @click="open = !open" 
        class="w-full flex items-center justify-between bg-blue-700 hover:bg-blue-600 px-3 py-2 rounded-lg transition">
        <div class="flex items-center gap-3">
            <div class="w-9 h-9 rounded-full bg-blue-400 flex items-center justify-center text-white font-bold text-sm">
                <?= strtoupper(substr($user_login['nama_lengkap'], 0, 1)); ?>
            </div>
            <div class="text-left">
                <p class="text-sm font-semibold text-white truncate w-28"><?= $user_login['nama_lengkap']; ?></p>
                <p class="text-xs text-blue-200 capitalize"><?= $user_login['role']; ?></p>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-blue-200 transition-transform duration-200" 
             :class="{ 'rotate-180': open }" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <!-- Dropdown -->
    <div x-show="open" 
        @click.away="open = false"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 translate-y-2"
        x-transition:enter-end="opacity-100 translate-y-0"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100 translate-y-0"
        x-transition:leave-end="opacity-0 translate-y-2"
        class="absolute left-0 bottom-16 w-full bg-blue-700 text-white rounded-lg shadow-lg border border-blue-600 overflow-hidden z-50">
        
        <ul class="text-sm divide-y divide-blue-600">
            <?php if ($user_login['role'] === 'user'): ?>
            <li>
                <a href="ubah_password.php" 
                   class="flex items-center gap-2 px-4 py-2 hover:bg-blue-600 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" 
                         stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-blue-200">
                        <path stroke-linecap="round" stroke-linejoin="round" 
                              d="M16.5 10.5V6a4.5 4.5 0 0 0-9 0v4.5M3 10.5h18v10.125A1.125 1.125 0 0 1 19.875 21H4.125A1.125 1.125 0 0 1 3 20.625V10.5Z" />
                    </svg>
                    <span>Ubah Password</span>
                </a>
            </li>
            <?php endif; ?>
            <li>
                <a href="logout.php" 
                   class="flex items-center gap-2 px-4 py-2 hover:bg-blue-600 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" 
                         stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                        <path stroke-linecap="round" stroke-linejoin="round" 
                              d="M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6A2.25 2.25 0 0 0 5.25 5.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15M9 12h12.75" />
                    </svg>
                    <span>Logout</span>
                </a>
            </li>
        </ul>
    </div>
</div>
<!-- Alpine.js -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</aside>

<!-- Main Content -->
<main class="flex-1 p-6">
<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold">Data Mahasiswa</h1>
    <div class="flex gap-2">
        <button onclick="document.getElementById('filterModal').classList.remove('hidden')" 
                class="px-4 py-2 rounded bg-blue-600 hover:bg-blue-700 text-white">
            Filter
        </button>
        <a href="export_excel.php?<?= http_build_query($_GET); ?>" 
           class="px-4 py-2 rounded bg-green-600 hover:bg-green-700 text-white">
            Export Excel
        </a>
    </div>
</div>

    <div class="bg-white shadow rounded-lg p-4 overflow-x-auto">
        <table class="min-w-full border border-gray-300 rounded-lg">
            <thead class="bg-gray-200">
                <tr>
                    <th class="border px-3 py-2 text-left">NIM</th>
                    <th class="border px-3 py-2 text-left">Jenjang</th>
                    <th class="border px-3 py-2 text-left">Nama</th>
                    <th class="border px-3 py-2 text-left">Fakultas</th>
                    <th class="border px-3 py-2 text-left">Program Studi</th>
                    <th class="border px-3 py-2 text-left">Angkatan</th>
                    <th class="border px-3 py-2 text-left">Jalur Masuk</th>
                    <th class="border px-3 py-2 text-left">Provinsi</th>
                    <th class="border px-3 py-2 text-left">Kota/Kab</th>
                    <th class="border px-3 py-2 text-left">Jenis Kelamin</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = mysqli_fetch_assoc($query)): ?>
                    <tr class="hover:bg-gray-100">
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['nim']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['nama_jenjang']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['nama_mahasiswa']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['nama_fakultas']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['nama_prodi']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['angkatan']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['nama_jalur']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['provinsi']); ?></td>
                        <td class="border px-3 py-2"><?= htmlspecialchars($row['kab_or_kota']); ?></td>
                        <td class="border px-3 py-2">
                            <?= $row['jenis_kelamin'] === 'L' ? 'Laki-Laki' : 'Perempuan'; ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
<!-- Pagination Tengah -->
<div class="flex justify-center items-center mt-6">
    <div class="flex gap-1">
        <?php if ($page > 1): ?>
            <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page - 1])) ?>" 
               class="px-3 py-1 bg-blue-600 text-white rounded hover:bg-blue-700">
                ‹
            </a>
        <?php endif; ?>

        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <a href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>" 
               class="px-3 py-1 rounded <?= $i == $page ? 'bg-blue-700 text-white' : 'bg-gray-200 hover:bg-gray-300' ?>">
                <?= $i ?>
            </a>
        <?php endfor; ?>

        <?php if ($page < $totalPages): ?>
            <a href="?<?= http_build_query(array_merge($_GET, ['page' => $page + 1])) ?>" 
               class="px-3 py-1 bg-blue-600 text-white rounded hover:bg-blue-700">
                ›
            </a>
        <?php endif; ?>
    </div>
</div>
</main>
</div>

<!-- Modal Filter -->
<div id="filterModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
    <div class="bg-white w-1/3 p-6 rounded shadow-lg relative max-h-[90vh] overflow-y-auto">
        <h2 class="text-xl font-bold mb-4">Filter Data Mahasiswa</h2>
        <form method="GET" action="">
            <div class="space-y-4">
                <!-- Angkatan -->
                <div>
                    <label class="block mb-1">Angkatan</label>
                    <select name="angkatan" class="w-full border px-3 py-2 rounded">
                        <option value="">Semua</option>
                        <?php while ($a = mysqli_fetch_assoc($angkatanRes)): ?>
                            <option value="<?= $a['angkatan']; ?>" 
                                <?= ($angkatan == $a['angkatan']) ? 'selected' : '' ?>>
                                <?= $a['angkatan']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <!-- Jenjang Pendidikan -->
                <div>
                    <label class="block mb-1">Jenjang Pendidikan</label>
                    <select name="jenjang" class="w-full border px-3 py-2 rounded">
                        <option value="all">Semua</option>
                        <?php while ($jj = mysqli_fetch_assoc($jenjangRes)): ?>
                            <option value="<?= $jj['id']; ?>" 
                                <?= ($jenjang == $jj['id']) ? 'selected' : '' ?>>
                                <?= $jj['nama_jenjang']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <!-- Fakultas -->
                <div>
                    <label class="block mb-1">Fakultas</label>
                    <select id="fakultasSelect" name="Fakultas" class="w-full border px-3 py-2 rounded">
                        <option value="all">Semua</option>
                        <?php while ($f = mysqli_fetch_assoc($fakultasRes)): ?>
                            <option value="<?= $f['nama_fakultas']; ?>" 
                                <?= ($fakultas == $f['nama_fakultas']) ? 'selected' : '' ?>>
                                <?= $f['nama_fakultas']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <!-- Prodi -->
                <div>
                    <label class="block mb-1">Program Studi</label>
                    <select id="prodiSelect" name="selectedProdi" class="w-full border px-3 py-2 rounded">
                        <option value="all">Semua</option>
                        <?php
                            if ($fakultas != "all") {
                                $prodiQuery = mysqli_query($conn, "SELECT p.nama_prodi 
                                                FROM program_studi p
                                                JOIN fakultas f ON p.fakultas_id = f.id
                                                WHERE f.nama_fakultas = '".mysqli_real_escape_string($conn, $fakultas)."'
                                                ORDER BY p.nama_prodi ASC");
                            while ($p = mysqli_fetch_assoc($prodiQuery)) {
                                $selected = ($selectedProdi == $p['nama_prodi']) ? 'selected' : '';
                                    echo "<option value='{$p['nama_prodi']}' $selected>{$p['nama_prodi']}</option>";
                            }
                        } else {
                // Jika tidak ada fakultas dipilih, tampilkan semua prodi
                                $prodiQuery = mysqli_query($conn, "SELECT nama_prodi FROM program_studi ORDER BY nama_prodi ASC");
                                    while ($p = mysqli_fetch_assoc($prodiQuery)) {
                                $selected = ($selectedProdi == $p['nama_prodi']) ? 'selected' : '';
                                echo "<option value='{$p['nama_prodi']}' $selected>{$p['nama_prodi']}</option>";
                            }
                        }
                        ?>
                    </select>
                </div>

                <!-- Jalur Masuk -->
                <div>
                    <label class="block mb-1">Jalur Masuk</label>
                    <select name="jalur_masuk" class="w-full border px-3 py-2 rounded">
                        <option value="">Semua</option>
                        <?php while ($j = mysqli_fetch_assoc($jalurRes)): ?>
                            <option value="<?= $j['nama_jalur']; ?>" 
                                <?= ($jalur_masuk == $j['nama_jalur']) ? 'selected' : '' ?>>
                                <?= $j['nama_jalur']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

<!-- Provinsi -->
<div>
    <label class="block mb-1">Provinsi</label>
    <select id="provinsiSelect" name="provinsi" class="w-full border px-3 py-2 rounded">
        <option value="">Semua</option>
        <?php 
        mysqli_data_seek($provinsiRes, 0); // reset pointer
        while ($pr = mysqli_fetch_assoc($provinsiRes)): ?>
            <option value="<?= $pr['provinsi']; ?>" 
                <?= ($provinsi == $pr['provinsi']) ? 'selected' : '' ?>>
                <?= $pr['provinsi']; ?>
            </option>
        <?php endwhile; ?>
    </select>
</div>

<!-- Kabupaten/Kota -->
<div>
    <label class="block mb-1">Kabupaten/Kota</label>
    <select id="kotaSelect" name="kab_or_kota" class="w-full border px-3 py-2 rounded">
        <option value="">Semua</option>
        <?php 
        if ($provinsi) {
            $kotaQuery = mysqli_query($conn, "SELECT DISTINCT kab_or_kota 
                                              FROM mahasiswa 
                                              WHERE provinsi = '".mysqli_real_escape_string($conn, $provinsi)."'
                                              ORDER BY kab_or_kota ASC");
            while ($k = mysqli_fetch_assoc($kotaQuery)) {
                $selected = ($kab_or_kota == $k['kab_or_kota']) ? 'selected' : '';
                echo "<option value='{$k['kab_or_kota']}' $selected>{$k['kab_or_kota']}</option>";
            }
        }
        ?>
    </select>
</div>


                <!-- Jenis Kelamin -->
                <div>
                    <label class="block mb-1">Jenis Kelamin</label>
                    <select name="jenis_kelamin" class="w-full border px-3 py-2 rounded">
                        <option value="">Semua</option>
                        <option value="L" <?= ($jenis_kelamin == "L") ? 'selected' : '' ?>>Laki-Laki</option>
                        <option value="P" <?= ($jenis_kelamin == "P") ? 'selected' : '' ?>>Perempuan</option>
                    </select>
                </div>
            </div>

            <div class="flex justify-end mt-6 space-x-2">
                <button type="button" onclick="document.getElementById('filterModal').classList.add('hidden')" 
                        class="px-4 py-2 rounded bg-gray-400 hover:bg-gray-500 text-white">Batal</button>
                <button type="submit" class="px-4 py-2 rounded bg-blue-600 hover:bg-blue-700 text-white">Terapkan</button>
            </div>
        </form>
    </div>
</div>

<!-- Script Prodi Dinamis -->
<script>
document.getElementById('fakultasSelect').addEventListener('change', function () {
    var fakultas = this.value;
    var prodiSelect = document.getElementById('prodiSelect');
    
    // kosongkan dulu dan tambahkan default
    prodiSelect.innerHTML = '<option value="all">Semua</option>';
    
    if (fakultas && fakultas !== "all") {
        fetch('get_prodi.php?Fakultas=' + encodeURIComponent(fakultas) + '&selectedProdi=<?= $selectedProdi ?>')
            .then(response => response.text())
            .then(html => {
                prodiSelect.innerHTML += html;
            });
    } else {
        // jika fakultas = all → ambil semua prodi
        fetch('get_prodi.php?Fakultas=all&selectedProdi=<?= $selectedProdi ?>')
            .then(response => response.text())
            .then(html => {
                prodiSelect.innerHTML += html;
            });
    }
});
</script>

<!-- Script Kabupaten/Kota Dinamis -->
 <script>
document.getElementById('provinsiSelect').addEventListener('change', function () {
    var provinsi = this.value;
    var kotaSelect = document.getElementById('kotaSelect');
    
    // kosongkan dulu
    kotaSelect.innerHTML = '<option value="">Semua</option>';
    
    if (provinsi && provinsi !== "all") {
        fetch('get_kota.php?Provinsi=' + encodeURIComponent(provinsi) + '&selectedKota=<?= $kab_or_kota ?>')
            .then(response => response.text())
            .then(html => {
                kotaSelect.innerHTML = html;
            });
    }
});
</script>
</body>
</html>
