<?php
session_start();
include "koneksi.php";

// Jika belum login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Ambil data user login
$username = $_SESSION['username'];
$user_login = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE username='$username'"));

// Cegah akses langsung ke halaman ini jika bukan admin
if ($user_login['role'] !== 'admin' && basename($_SERVER['PHP_SELF']) === 'data_user.php') {
    header("Location: index.php");
    exit();
}

// Tambah user
if (isset($_POST['tambah'])) {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $role = $_POST['role'];
    $password = md5($_POST['password']);

    $cek = mysqli_query($conn, "SELECT * FROM users WHERE username='$username'");
    if (mysqli_num_rows($cek) > 0) {
        $msg = "Username sudah digunakan!";
        $status = "error";
    } else {
        $insert = mysqli_query($conn, "INSERT INTO users (username, nama_lengkap, role, password) VALUES ('$username','$nama','$role','$password')");
        $msg = $insert ? "User berhasil ditambahkan!" : "Gagal menambahkan user.";
        $status = $insert ? "success" : "error";
    }
}

// Update user
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $role = $_POST['role'];
    $password = $_POST['password'] ? ", password='".md5($_POST['password'])."'" : "";

    $update = mysqli_query($conn, "UPDATE users SET nama_lengkap='$nama', role='$role' $password WHERE id='$id'");
    $msg = $update ? "Data user berhasil diupdate!" : "Gagal update data.";
    $status = $update ? "success" : "error";
}

// Hapus user
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    $delete = mysqli_query($conn, "DELETE FROM users WHERE id='$id'");
    $msg = $delete ? "User berhasil dihapus!" : "Gagal menghapus user.";
    $status = $delete ? "success" : "error";
}

// Ambil data user
$users = mysqli_query($conn, "SELECT * FROM users ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Data Pengguna - SIMABA</title>
    <link rel="icon" type="image/png" href="assets/L-o-g-o_U-P-R_s-t-a-t-u-t-a_2-0-1-7_Per-men-ris-tek-dik-ti42-2-0-1-7_j_t_s-RevOk240x240.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 font-sans">
<div class="flex min-h-screen">

<!-- SIDEBAR -->
<aside class="w-64 bg-blue-700 text-white flex flex-col justify-between shadow-lg">
    <div>
        <div class="p-6 border-b border-green-600 flex items-center justify-center gap-3">
            <img src="assets/L-o-g-o_U-P-R_s-t-a-t-u-t-a_2-0-1-7_Per-men-ris-tek-dik-ti42-2-0-1-7_j_t_s-RevOk240x240.png" alt="Logo UPR" class="w-12 h-12 rounded-full">
            <div>
                <h2 class="text-lg font-bold tracking-wide">SIMABA</h2>
                <p class="text-xs text-green-200">Universitas Palangka Raya</p>
            </div>
        </div>
        <nav class="mt-6 px-4">
            <ul class="space-y-2 font-medium">
                <!-- Dashboard -->
                <li>
                    <a href="index.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                    </svg>
                        Dashboard
                    </a>
                </li>
                <!-- Statistik -->
                <li>
                    <a href="statistik.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'statistik.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 0 1 3 19.875v-6.75ZM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V8.625ZM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V4.125Z" />
                    </svg>
                        Statistik
                    </a>
                </li>

                <!-- Data Mahasiswa -->
                <li>
                    <a href="data_mahasiswa.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'data_mahasiswa.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 0 1-1.125-1.125M3.375 19.5h7.5c.621 0 1.125-.504 1.125-1.125m-9.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-7.5A1.125 1.125 0 0 1 12 18.375m9.75-12.75c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125m19.5 0v1.5c0 .621-.504 1.125-1.125 1.125M2.25 5.625v1.5c0 .621.504 1.125 1.125 1.125m0 0h17.25m-17.25 0h7.5c.621 0 1.125.504 1.125 1.125M3.375 8.25c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m17.25-3.75h-7.5c-.621 0-1.125.504-1.125 1.125m8.625-1.125c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M12 10.875v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125M13.125 12h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125M20.625 12c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5M12 14.625v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 14.625c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m0 1.5v-1.5m0 0c0-.621.504-1.125 1.125-1.125m0 0h7.5" />
                    </svg>
                        Data Mahasiswa
                    </a>
                </li>

                <!-- Helpdesk -->
                 <?php if ($user_login['role'] === 'admin'): ?>
                <li>
                    <a href="helpdesk_list.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'helpdesk_list.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126ZM12 15.75h.007v.008H12v-.008Z" />
                    </svg>

                        Helpdesk
                    </a>
                </li>
                <?php endif; ?>

                <!-- Data Pengguna (hanya admin) -->
                <?php if ($user_login['role'] === 'admin'): ?>
                <li>
                    <a href="data_user.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'data_user.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                    </svg>
                        Data Pengguna
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>

<!-- PROFIL PENGGUNA (Sidebar bawah, versi rapi & konsisten) -->
<div class="relative p-4 border-t border-blue-700" x-data="{ open: false }">
    <!-- Tombol nama pengguna -->
    <button @click="open = !open" 
        class="w-full flex items-center justify-between bg-blue-700 hover:bg-blue-600 px-3 py-2 rounded-lg transition">
        <div class="flex items-center gap-3">
            <div class="w-9 h-9 rounded-full bg-blue-400 flex items-center justify-center text-white font-bold text-sm">
                <?= strtoupper(substr($user_login['nama_lengkap'], 0, 1)); ?>
            </div>
            <div class="text-left">
                <p class="text-sm font-semibold text-white truncate w-28"><?= $user_login['nama_lengkap']; ?></p>
                <p class="text-xs text-blue-200 capitalize"><?= $user_login['role']; ?></p>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-blue-200 transition-transform duration-200" 
             :class="{ 'rotate-180': open }" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <!-- Dropdown -->
    <div x-show="open" 
        @click.away="open = false"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 translate-y-2"
        x-transition:enter-end="opacity-100 translate-y-0"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100 translate-y-0"
        x-transition:leave-end="opacity-0 translate-y-2"
        class="absolute left-0 bottom-16 w-full bg-blue-700 text-white rounded-lg shadow-lg border border-blue-600 overflow-hidden z-50">
        
        <ul class="text-sm divide-y divide-blue-600">
            <?php if ($user_login['role'] === 'user'): ?>
            <li>
                <a href="ubah_password.php" 
                   class="flex items-center gap-2 px-4 py-2 hover:bg-blue-600 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" 
                         stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-blue-200">
                        <path stroke-linecap="round" stroke-linejoin="round" 
                              d="M16.5 10.5V6a4.5 4.5 0 0 0-9 0v4.5M3 10.5h18v10.125A1.125 1.125 0 0 1 19.875 21H4.125A1.125 1.125 0 0 1 3 20.625V10.5Z" />
                    </svg>
                    <span>Ubah Password</span>
                </a>
            </li>
            <?php endif; ?>
            <li>
                <a href="logout.php" 
                   class="flex items-center gap-2 px-4 py-2 hover:bg-blue-600 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" 
                         stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                        <path stroke-linecap="round" stroke-linejoin="round" 
                              d="M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6A2.25 2.25 0 0 0 5.25 5.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15M9 12h12.75" />
                    </svg>
                    <span>Logout</span>
                </a>
            </li>
        </ul>
    </div>
</div>
<!-- Alpine.js -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</aside>

<!-- Main Content -->
<main class="flex-1 p-6">
    <h1 class="text-2xl font-bold mb-6">Data Pengguna</h1>

    <button onclick="document.getElementById('formTambah').classList.toggle('hidden')" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded mb-4">+ Tambah User</button>

    <div id="formTambah" class="hidden bg-white p-4 rounded shadow mb-6">
        <form method="POST">
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-semibold mb-1">Username</label>
                    <input type="text" name="username" class="w-full border p-2 rounded" required>
                </div>
                <div>
                    <label class="block text-sm font-semibold mb-1">Nama Lengkap</label>
                    <input type="text" name="nama" class="w-full border p-2 rounded" required>
                </div>
                <div>
                    <label class="block text-sm font-semibold mb-1">Role</label>
                    <select name="role" class="w-full border p-2 rounded" required>
                        <option value="admin">Admin</option>
                        <option value="user">User</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-semibold mb-1">Password</label>
                    <input type="password" name="password" class="w-full border p-2 rounded" required>
                </div>
            </div>
            <button type="submit" name="tambah" class="mt-4 bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">Simpan</button>
        </form>
    </div>

    <div class="bg-white p-4 rounded shadow overflow-x-auto">
        <table class="w-full border-collapse">
            <thead class="bg-blue-600 text-white">
                <tr>
                    <th class="p-2 text-left">No</th>
                    <th class="p-2 text-left">Username</th>
                    <th class="p-2 text-left">Nama Lengkap</th>
                    <th class="p-2 text-left">Role</th>
                    <th class="p-2 text-left">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $no=1; while($row = mysqli_fetch_assoc($users)): ?>
                <tr class="border-b hover:bg-gray-50">
                    <td class="p-2"><?php echo $no++; ?></td>
                    <td class="p-2"><?php echo $row['username']; ?></td>
                    <td class="p-2"><?php echo $row['nama_lengkap']; ?></td>
                    <td class="p-2 capitalize"><?php echo $row['role']; ?></td>
                    <td class="p-2">
                        <button onclick="editUser(<?php echo htmlspecialchars(json_encode($row)); ?>)" class="bg-yellow-400 hover:bg-yellow-500 text-white px-2 py-1 rounded text-sm">Edit</button>
                        <a href="?hapus=<?php echo $row['id']; ?>" onclick="return confirm('Yakin ingin menghapus user ini?')" class="bg-red-500 hover:bg-red-600 text-white px-2 py-1 rounded text-sm">Hapus</a>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</main>
</div>

<script>
<?php if(isset($msg)): ?>
Swal.fire({
    icon: '<?php echo $status; ?>',
    title: '<?php echo ucfirst($status); ?>',
    text: '<?php echo $msg; ?>',
    timer: 2000,
    showConfirmButton: false
});
<?php endif; ?>

function editUser(user) {
    Swal.fire({
        title: 'Edit Data User',
        html: `
        <form id="editForm" method="POST">
            <input type="hidden" name="id" value="${user.id}">
            <label class="block text-sm font-semibold mt-2">Nama Lengkap</label>
            <input name="nama" class="swal2-input" value="${user.nama_lengkap}">
            <label class="block text-sm font-semibold mt-2">Role</label>
            <select name="role" class="swal2-select">
                <option value="admin" ${user.role==='admin'?'selected':''}>Admin</option>
                <option value="user" ${user.role==='user'?'selected':''}>User</option>
            </select>
            <label class="block text-sm font-semibold mt-2">Password (kosongkan jika tidak diubah)</label>
            <input type="password" name="password" class="swal2-input">
            <input type="hidden" name="update" value="1">
        </form>
        `,
        showCancelButton: true,
        confirmButtonText: 'Simpan',
        preConfirm: () => {
            document.getElementById('editForm').submit();
        }
    });
}
</script>
</body>
</html>
