<?php
session_start();
include "koneksi.php";

// Pastikan user login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// --- Ambil filter dari GET ---
$angkatan      = $_GET['angkatan']      ?? "";
$fakultas      = $_GET['Fakultas']      ?? "all";
$selectedProdi = $_GET['selectedProdi'] ?? "all";
$jalur_masuk   = $_GET['jalur_masuk']   ?? "";
$provinsi      = $_GET['provinsi']      ?? "";
$kab_or_kota   = $_GET['kab_or_kota']   ?? "";
$jenis_kelamin = $_GET['jenis_kelamin'] ?? "";
$jenjang       = $_GET['jenjang']       ?? "all";

// --- Nama file dinamis ---
$parts = ["data_mahasiswa"];
if ($angkatan)      $parts[] = "Angkatan-".$angkatan;
if ($jenjang != "all") {
    $jenjangRes = mysqli_query($conn, "SELECT nama_jenjang FROM jenjang_pendidikan WHERE id='".mysqli_real_escape_string($conn, $jenjang)."' LIMIT 1");
    if ($jj = mysqli_fetch_assoc($jenjangRes)) {
        $parts[] = "Jenjang-".$jj['nama_jenjang'];
    }
}
if ($fakultas != "all") $parts[] = "Fakultas-".str_replace(" ", "_", $fakultas);
if ($selectedProdi != "all") $parts[] = "Prodi-".str_replace(" ", "_", $selectedProdi);
if ($jalur_masuk)   $parts[] = "Jalur-".str_replace(" ", "_", $jalur_masuk);
if ($provinsi)      $parts[] = "Provinsi-".str_replace(" ", "_", $provinsi);
if ($kab_or_kota)   $parts[] = "Kota-".str_replace(" ", "_", $kab_or_kota);
if ($jenis_kelamin) $parts[] = "Gender-".($jenis_kelamin == "L" ? "L" : "P");

// Gabung jadi nama file
$filename = implode("_", $parts).".xls";

// --- Query Data Mahasiswa ---
$sql = "
    SELECT m.nim, jp.nama_jenjang, m.nama_mahasiswa, 
           f.nama_fakultas, p.nama_prodi, 
           m.angkatan, jm.nama_jalur, 
           m.provinsi, m.kab_or_kota, 
           CASE m.jenis_kelamin WHEN 'L' THEN 'Laki-Laki' ELSE 'Perempuan' END AS jenis_kelamin
    FROM mahasiswa m
    JOIN jenjang_pendidikan jp ON m.jenjang_id = jp.id
    JOIN fakultas f ON m.fakultas_id = f.id
    JOIN program_studi p ON m.program_studi_id = p.id
    JOIN jalur_masuk jm ON m.jalur_masuk_id = jm.id
    WHERE 1=1
";

if ($angkatan)      $sql .= " AND m.angkatan = '".mysqli_real_escape_string($conn, $angkatan)."'";
if ($jenjang != "all") $sql .= " AND jp.id = '".mysqli_real_escape_string($conn, $jenjang)."'";
if ($fakultas != "all") $sql .= " AND f.nama_fakultas = '".mysqli_real_escape_string($conn, $fakultas)."'";
if ($selectedProdi != "all") $sql .= " AND p.nama_prodi = '".mysqli_real_escape_string($conn, $selectedProdi)."'";
if ($jalur_masuk)   $sql .= " AND jm.nama_jalur = '".mysqli_real_escape_string($conn, $jalur_masuk)."'";
if ($provinsi)      $sql .= " AND m.provinsi = '".mysqli_real_escape_string($conn, $provinsi)."'";
if ($kab_or_kota)   $sql .= " AND m.kab_or_kota = '".mysqli_real_escape_string($conn, $kab_or_kota)."'";
if ($jenis_kelamin) $sql .= " AND m.jenis_kelamin = '".mysqli_real_escape_string($conn, $jenis_kelamin)."'";

$sql .= " ORDER BY m.angkatan DESC, m.nama_mahasiswa ASC";
$result = mysqli_query($conn, $sql);

// --- Set header untuk download Excel ---
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Pragma: no-cache");
header("Expires: 0");

// --- Buat tabel Excel ---
echo "<table border='1'>";
echo "<tr>
        <th>NIM</th>
        <th>Jenjang</th>
        <th>Nama</th>
        <th>Fakultas</th>
        <th>Program Studi</th>
        <th>Angkatan</th>
        <th>Jalur Masuk</th>
        <th>Provinsi</th>
        <th>Kabupaten/Kota</th>
        <th>Jenis Kelamin</th>
      </tr>";

while ($row = mysqli_fetch_assoc($result)) {
    echo "<tr>
            <td>".htmlspecialchars($row['nim'])."</td>
            <td>".htmlspecialchars($row['nama_jenjang'])."</td>
            <td>".htmlspecialchars($row['nama_mahasiswa'])."</td>
            <td>".htmlspecialchars($row['nama_fakultas'])."</td>
            <td>".htmlspecialchars($row['nama_prodi'])."</td>
            <td>".htmlspecialchars($row['angkatan'])."</td>
            <td>".htmlspecialchars($row['nama_jalur'])."</td>
            <td>".htmlspecialchars($row['provinsi'])."</td>
            <td>".htmlspecialchars($row['kab_or_kota'])."</td>
            <td>".htmlspecialchars($row['jenis_kelamin'])."</td>
          </tr>";
}
echo "</table>";
