<?php
include "koneksi.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username   = mysqli_real_escape_string($conn, $_POST['username']);
    $email      = mysqli_real_escape_string($conn, $_POST['email']);
    $whatsapp   = mysqli_real_escape_string($conn, $_POST['whatsapp']);
    $topic      = mysqli_real_escape_string($conn, $_POST['topic']);
    $desc       = mysqli_real_escape_string($conn, $_POST['description']);

    // --- Upload Foto ---
    $fotoName = null;
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] == 0) {
        $targetDir = "uploads/";
        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0777, true); // buat folder kalau belum ada
        }

        $fileName = time() . "_" . basename($_FILES["foto"]["name"]);
        $targetFile = $targetDir . $fileName;

        // validasi ekstensi file
        $allowedExt = ['jpg','jpeg','png','gif'];
        $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

        if (in_array($fileExt, $allowedExt)) {
            if (move_uploaded_file($_FILES["foto"]["tmp_name"], $targetFile)) {
                $fotoName = $fileName;
            }
        }
    }

    $sql = "INSERT INTO helpdesk (username, email, whatsapp, topic, description, foto) 
            VALUES ('$username', '$email', '$whatsapp', '$topic', '$desc', " . ($fotoName ? "'$fotoName'" : "NULL") . ")";

    if (mysqli_query($conn, $sql)) {
        $status = "success";
        $message = "Aduan berhasil dikirim!";
    } else {
        $status = "error";
        $message = "Terjadi kesalahan: " . mysqli_error($conn);
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Helpdesk - SIMABA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 flex justify-center py-10">

<div class="bg-white shadow-lg rounded-lg p-8 w-full max-w-lg">
    <h2 class="text-2xl font-bold mb-6 text-center text-green-700">Helpdesk SIMABA</h2>
    <form method="POST" enctype="multipart/form-data">
        <label class="block mb-2">Username</label>
        <input type="text" name="username" required class="w-full border rounded px-3 py-2 mb-4">

        <label class="block mb-2">Email</label>
        <input type="email" name="email" required class="w-full border rounded px-3 py-2 mb-4">

        <label class="block mb-2">WhatsApp</label>
        <input type="text" name="whatsapp" class="w-full border rounded px-3 py-2 mb-4">

        <label class="block mb-2">Topik</label>
        <select name="topic" required class="w-full border rounded px-3 py-2 mb-4">
            <option value="">Pilih Topik</option>
            <option value="Login">Masalah Login</option>
            <option value="Data">Masalah Data</option>
            <option value="Lainnya">Lainnya</option>
        </select>

        <label class="block mb-2">Deskripsi</label>
        <textarea name="description" required class="w-full border rounded px-3 py-2 mb-4"></textarea>

        <!-- Upload Foto -->
        <label class="block mb-2">Upload Foto (opsional)</label>
        <input type="file" name="foto" accept=".jpg,.jpeg,.png,.gif" 
               class="w-full border rounded px-3 py-2 mb-4">

        <div class="flex justify-between gap-2">
            <!-- Tombol Kirim -->
            <button type="submit" 
                class="flex-1 bg-green-600 text-white py-2 rounded hover:bg-green-700">
                Kirim Aduan
            </button>

            <!-- Tombol Kembali ke Login -->
            <a href="login.php" 
               class="flex-1 text-center bg-gray-400 text-white py-2 rounded hover:bg-gray-500">
               Kembali ke Login
            </a>
        </div>
    </form>
</div>

<?php if (isset($status)): ?>
<script>
Swal.fire({
    icon: '<?= $status ?>',
    title: 'Informasi',
    text: '<?= $message ?>',
    showConfirmButton: false,
    timer: 2000
});
</script>
<?php endif; ?>

</body>
</html>
