<?php
session_start();
include "koneksi.php";

// Load PhpSpreadsheet jika file Excel
require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

// ======================
// Fungsi bantu
// ======================
function find_id_by_name($conn, $table, $col, $name) {
    $name = trim($name);
    if ($name === '') return null;
    $safe = mysqli_real_escape_string($conn, mb_strtolower($name, 'UTF-8'));
    $sql = "SELECT id FROM `$table` WHERE LOWER($col) = '$safe' LIMIT 1";
    $res = mysqli_query($conn, $sql);
    if ($res && mysqli_num_rows($res) > 0) {
        $r = mysqli_fetch_assoc($res);
        return $r['id'];
    }
    return null;
}

function get_default_jenjang($conn) {
    $res = mysqli_query($conn, "SELECT id FROM jenjang_pendidikan ORDER BY id ASC LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) {
        $r = mysqli_fetch_assoc($res);
        return $r['id'];
    }
    return null;
}

function val_from_row($row, $map, $names) {
    foreach ($names as $n) {
        $k = strtolower(trim($n));
        if (isset($map[$k]) && isset($row[$map[$k]])) {
            return trim($row[$map[$k]]);
        }
    }
    return "";
}

// ======================
// Validasi File Upload
// ======================
if (!isset($_FILES['file_csv']) || $_FILES['file_csv']['error'] != 0) {
    header("Location: index.php?status=error&icon=error&message=" . urlencode("File tidak diupload atau terjadi error upload"));
    exit;
}

$filename = $_FILES['file_csv']['tmp_name'];
$ext = strtolower(pathinfo($_FILES['file_csv']['name'], PATHINFO_EXTENSION));

// ======================
// Baca File (Excel atau CSV)
// ======================
$rows = [];
if (in_array($ext, ['xlsx', 'xls'])) {
    try {
        $spreadsheet = IOFactory::load($filename);
        $sheet = $spreadsheet->getActiveSheet();
        foreach ($sheet->toArray() as $row) {
            $rows[] = $row;
        }
    } catch (Exception $e) {
        header("Location: index.php?status=error&icon=error&message=" . urlencode("Gagal membaca file Excel: " . $e->getMessage()));
        exit;
    }
} elseif ($ext === 'csv') {
    $handle = fopen($filename, "r");
    if ($handle === FALSE) {
        header("Location: index.php?status=error&icon=error&message=" . urlencode("Tidak bisa membuka file CSV"));
        exit;
    }
    stream_filter_append($handle, 'convert.iconv.ISO-8859-1/UTF-8');
    while (($data = fgetcsv($handle, 0, ",")) !== FALSE) {
        $rows[] = $data;
    }
    fclose($handle);
} else {
    header("Location: index.php?status=error&icon=error&message=" . urlencode("Format file tidak didukung. Gunakan .csv atau .xlsx"));
    exit;
}

// ======================
// Baca Header
// ======================
if (count($rows) < 2) {
    header("Location: index.php?status=error&icon=error&message=" . urlencode("File tidak berisi data"));
    exit;
}

$header = array_map('trim', $rows[0]);
$map = [];
foreach ($header as $i => $col) {
    $map[strtolower($col)] = $i;
}

// ======================
// Proses Baris Data
// ======================
$success = $updated = $duplicate = $failed = 0;
$details = [];
$default_jenjang = get_default_jenjang($conn);

for ($r = 1; $r < count($rows); $r++) {
    $data = $rows[$r];
    $rowNumber = $r + 1;

    $nim          = val_from_row($data, $map, ['nim']);
    $nama         = val_from_row($data, $map, ['nama_mahasiswa','nama']);
    $prodi_nama   = val_from_row($data, $map, ['program_studi','nama_prodi','prodi']);
    $fakultas_nama= val_from_row($data, $map, ['fakultas','nama_fakultas']);
    $angkatan     = val_from_row($data, $map, ['angkatan','tahun']);
    $provinsi     = val_from_row($data, $map, ['provinsi']);
    $kabkota      = val_from_row($data, $map, ['kab_or_kota','kab_kota','kota']);
    $kelamin      = val_from_row($data, $map, ['jenis_kelamin','kelamin']);
    $jalur_nama   = val_from_row($data, $map, ['jalur_masuk','jalur']);
    $jenjang_nama = val_from_row($data, $map, ['jenjang','jenjang_pendidikan']);

    if ($nim === '' || $nama === '') {
        $failed++;
        $details[] = "Baris $rowNumber: NIM atau Nama kosong";
        continue;
    }

    // Ambil ID relasi
    $fakultas_id = find_id_by_name($conn, 'fakultas', 'nama_fakultas', $fakultas_nama);
    $prodi_id    = find_id_by_name($conn, 'program_studi', 'nama_prodi', $prodi_nama);
    $jalur_id    = find_id_by_name($conn, 'jalur_masuk', 'nama_jalur', $jalur_nama);
    $jenjang_id  = $jenjang_nama !== '' 
        ? find_id_by_name($conn, 'jenjang_pendidikan', 'nama_jenjang', $jenjang_nama)
        : $default_jenjang;

    $missing = [];
    if (!$fakultas_id) $missing[] = "Fakultas('$fakultas_nama')";
    if (!$prodi_id)    $missing[] = "Prodi('$prodi_nama')";
    if (!$jalur_id)    $missing[] = "Jalur('$jalur_nama')";
    if (!$jenjang_id)  $missing[] = "Jenjang('$jenjang_nama')";

    if (!empty($missing)) {
        $failed++;
        $details[] = "Baris $rowNumber: relasi tidak ditemukan - " . implode(", ", $missing);
        continue;
    }

    $nim_e       = mysqli_real_escape_string($conn, $nim);
    $nama_e      = mysqli_real_escape_string($conn, $nama);
    $provinsi_e  = mysqli_real_escape_string($conn, $provinsi);
    $kabkota_e   = mysqli_real_escape_string($conn, $kabkota);
    $kelamin_e   = mysqli_real_escape_string($conn, $kelamin);
    $angkatan_e  = mysqli_real_escape_string($conn, $angkatan);

    $qcek = mysqli_query($conn, "SELECT * FROM mahasiswa WHERE nim = '$nim_e' LIMIT 1");

    if ($qcek && mysqli_num_rows($qcek) > 0) {
        $existing = mysqli_fetch_assoc($qcek);
        $id_existing = (int)$existing['id'];

        $isDifferent = (
            $existing['nama_mahasiswa'] !== $nama_e ||
            $existing['program_studi_id'] != $prodi_id ||
            $existing['fakultas_id'] != $fakultas_id ||
            $existing['angkatan'] != $angkatan_e ||
            $existing['provinsi'] !== $provinsi_e ||
            $existing['kab_or_kota'] !== $kabkota_e ||
            $existing['jenis_kelamin'] !== $kelamin_e ||
            $existing['jalur_masuk_id'] != $jalur_id ||
            $existing['jenjang_id'] != $jenjang_id
        );

        if ($isDifferent) {
            $sql = "UPDATE mahasiswa SET 
                        nama_mahasiswa = '$nama_e',
                        program_studi_id = $prodi_id,
                        fakultas_id = $fakultas_id,
                        angkatan = '$angkatan_e',
                        provinsi = '$provinsi_e',
                        kab_or_kota = '$kabkota_e',
                        jenis_kelamin = '$kelamin_e',
                        jalur_masuk_id = $jalur_id,
                        jenjang_id = $jenjang_id
                    WHERE id = $id_existing";
            $res = mysqli_query($conn, $sql);
            if ($res) {
                $updated++;
                $details[] = "Baris $rowNumber: Data NIM $nim diperbarui";
            } else {
                $failed++;
                $details[] = "Baris $rowNumber: Gagal update (" . mysqli_error($conn) . ")";
            }
        } else {
            $duplicate++;
            $details[] = "Baris $rowNumber: NIM $nim sudah ada (tidak ada perubahan)";
        }
    } else {
        $sql = "INSERT INTO mahasiswa
                (nim, nama_mahasiswa, program_studi_id, fakultas_id, angkatan, provinsi, kab_or_kota, jenis_kelamin, jalur_masuk_id, jenjang_id)
                VALUES (
                    '$nim_e', '$nama_e', $prodi_id, $fakultas_id, '$angkatan_e',
                    '$provinsi_e', '$kabkota_e', '$kelamin_e', $jalur_id, $jenjang_id
                )";
        $res = mysqli_query($conn, $sql);
        if ($res) {
            $success++;
            $details[] = "Baris $rowNumber: NIM $nim berhasil ditambahkan";
        } else {
            $failed++;
            $details[] = "Baris $rowNumber: Gagal insert (" . mysqli_error($conn) . ")";
        }
    }
}

// ======================
// Simpan hasil ke session
// ======================
$_SESSION['import_summary'] = [
    'success' => $success,
    'updated' => $updated,
    'duplicate' => $duplicate,
    'failed' => $failed,
    'details' => $details
];

$totalMsg = "Import selesai: $success tambah, $updated update, $duplicate duplikat, $failed gagal";
$status = ($failed > 0) ? "error" : "success";
$icon = ($failed > 0) ? "error" : "success";

header("Location: index.php?status=$status&icon=$icon&message=" . urlencode($totalMsg));
exit;
?>
