<?php
session_start();
include "koneksi.php";

$status = null;
$message = null;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = $_POST['password'];

    $res = mysqli_query($conn, "SELECT * FROM users WHERE username='$username' LIMIT 1");
    $user = mysqli_fetch_assoc($res);

    if ($user) {
        if ($user['password'] === md5($password)) {
            // ✅ Simpan session
            $_SESSION['username'] = $user['username'];
            $status = "success";
            $message = "Login berhasil! Selamat datang, " . htmlspecialchars($user['nama_lengkap']);
        } else {
            $status = "error";
            $message = "Password salah!";
        }
    } else {
        $status = "error";
        $message = "Username tidak ditemukan!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login SIMABA</title>
    <link rel="icon" type="image/png" href="assets/L-o-g-o_U-P-R_s-t-a-t-u-t-a_2-0-1-7_Per-men-ris-tek-dik-ti42-2-0-1-7_j_t_s-RevOk240x240.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">

<div class="bg-white shadow-lg rounded-lg p-8 w-96">
    <h2 class="text-2xl font-bold mb-6 text-center">Login SIMABA</h2>

    <form method="POST">
        <label class="block mb-2 font-medium">Username</label>
        <input type="text" name="username" required 
               class="w-full border rounded px-3 py-2 mb-4">

        <label class="block mb-2 font-medium">Password</label>
        <input type="password" name="password" required 
               class="w-full border rounded px-3 py-2 mb-6">

        <button type="submit" 
                class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">
            Login
        </button>
    </form>

    <p class="text-center text-sm text-gray-600 mt-6">
        Support and Helpdesk: 
        <a href="helpdesk.php" class="text-green-600 font-semibold hover:underline">
            Helpdesk
        </a>
    </p>
</div>

<?php if ($status): ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    <?php if ($status === "success"): ?>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil',
            text: '<?= $message ?>',
            showConfirmButton: false,
            timer: 1500,
            timerProgressBar: true
        }).then(() => {
            window.location.href = "index.php";
        });
    <?php else: ?>
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: '<?= $message ?>',
            confirmButtonText: 'OK',
            confirmButtonColor: '#3085d6'
        });
    <?php endif; ?>
});
</script>
<?php endif; ?>

</body>
</html>
