<?php
include "koneksi.php";

$q = $_GET['q'] ?? '';
$angkatan      = $_GET['angkatan']      ?? "";
$fakultas      = $_GET['Fakultas']      ?? "all";
$selectedProdi = $_GET['selectedProdi'] ?? "all";
$jalur_masuk   = $_GET['jalur_masuk']   ?? "";
$provinsi      = $_GET['provinsi']      ?? "";
$kab_or_kota   = $_GET['kab_or_kota']   ?? "";
$jenis_kelamin = $_GET['jenis_kelamin'] ?? "";
$jenjang       = $_GET['jenjang']       ?? "all";

// --- Base Query
$sql = "
    SELECT m.id, m.nim, m.nama_mahasiswa, 
           jp.nama_jenjang,
           f.nama_fakultas, p.nama_prodi, 
           m.angkatan, jm.nama_jalur, 
           m.provinsi, m.kab_or_kota, m.jenis_kelamin
    FROM mahasiswa m
    JOIN jenjang_pendidikan jp ON m.jenjang_id = jp.id
    JOIN fakultas f ON m.fakultas_id = f.id
    JOIN program_studi p ON m.program_studi_id = p.id
    JOIN jalur_masuk jm ON m.jalur_masuk_id = jm.id
    WHERE 1=1
";

// --- Terapkan Filter
if ($angkatan)      $sql .= " AND m.angkatan = '".mysqli_real_escape_string($conn, $angkatan)."'";
if ($jenjang != "all") $sql .= " AND jp.id = '".mysqli_real_escape_string($conn, $jenjang)."'";
if ($fakultas != "all") $sql .= " AND f.nama_fakultas = '".mysqli_real_escape_string($conn, $fakultas)."'";
if ($selectedProdi != "all") $sql .= " AND p.nama_prodi = '".mysqli_real_escape_string($conn, $selectedProdi)."'";
if ($jalur_masuk)   $sql .= " AND jm.nama_jalur = '".mysqli_real_escape_string($conn, $jalur_masuk)."'";
if ($provinsi)      $sql .= " AND m.provinsi = '".mysqli_real_escape_string($conn, $provinsi)."'";
if ($kab_or_kota)   $sql .= " AND m.kab_or_kota = '".mysqli_real_escape_string($conn, $kab_or_kota)."'";
if ($jenis_kelamin) $sql .= " AND m.jenis_kelamin = '".mysqli_real_escape_string($conn, $jenis_kelamin)."'";

// --- 🔍 Filter Search Keyword
if ($q) {
    $q_esc = mysqli_real_escape_string($conn, $q);
    $sql .= " AND (m.nim LIKE '%$q_esc%' 
                OR m.nama_mahasiswa LIKE '%$q_esc%'
                OR f.nama_fakultas LIKE '%$q_esc%'
                OR p.nama_prodi LIKE '%$q_esc%'
                OR m.provinsi LIKE '%$q_esc%'
                OR m.kab_or_kota LIKE '%$q_esc%')";
}

$sql .= " ORDER BY m.angkatan DESC, m.nama_mahasiswa ASC";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<tr class='hover:bg-gray-100'>
                <td class='border px-3 py-2'>".htmlspecialchars($row['nim'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['nama_jenjang'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['nama_mahasiswa'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['nama_fakultas'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['nama_prodi'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['angkatan'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['nama_jalur'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['provinsi'])."</td>
                <td class='border px-3 py-2'>".htmlspecialchars($row['kab_or_kota'])."</td>
                <td class='border px-3 py-2'>".($row['jenis_kelamin']=='L'?'Laki-Laki':'Perempuan')."</td>
              </tr>";
    }
} else {
    echo "<tr><td colspan='10' class='text-center text-gray-500 py-4'>Tidak ada data ditemukan.</td></tr>";
}
?>
