<?php
session_start();
include "koneksi.php";

// Pastikan user sudah login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Ambil data user login
$username = $_SESSION['username'] ?? null;
$user_login = null;

if ($username) {
    $query_user = mysqli_query($conn, "SELECT * FROM users WHERE username='$username' LIMIT 1");
    if ($query_user && mysqli_num_rows($query_user) > 0) {
        $user_login = mysqli_fetch_assoc($query_user);
    }
}

// Jika user_login masih null (tidak ditemukan di database), redirect ke logout
if (!$user_login) {
    header("Location: logout.php");
    exit();
}

// --- Jika request AJAX untuk ambil prodi ---
if (isset($_GET['ajax']) && $_GET['ajax'] == "getProdi") {
    $fakultas = $_GET['fakultas'] ?? "all";
    $selectedProdi = $_GET['selectedProdi'] ?? "all";

    if ($fakultas != "all") {
        $sql = "SELECT id, nama_prodi 
                FROM program_studi 
                WHERE fakultas_id = '".mysqli_real_escape_string($conn, $fakultas)."'
                ORDER BY nama_prodi ASC";
    } else {
        $sql = "SELECT id, nama_prodi FROM program_studi ORDER BY nama_prodi ASC";
    }

    $res = mysqli_query($conn, $sql);

    while ($row = mysqli_fetch_assoc($res)) {
        $id = $row['id'];
        $namaProdi = htmlspecialchars($row['nama_prodi']);
        $selected = ($selectedProdi == $id) ? "selected" : "";
        echo "<option value='$id' $selected>$namaProdi</option>";
    }
    exit;
}

// --- Ambil dropdown data ---
$fakultas_q = mysqli_query($conn, "SELECT id, nama_fakultas FROM fakultas ORDER BY nama_fakultas");
$jalur_q    = mysqli_query($conn, "SELECT id, nama_jalur FROM jalur_masuk ORDER BY nama_jalur");
$jenjang_q  = mysqli_query($conn, "SELECT id, nama_jenjang FROM jenjang_pendidikan ORDER BY nama_jenjang");

// --- Ambil filter dari GET ---
$fakultas = $_GET['fakultas'] ?? 'all';
$prodi    = $_GET['prodi'] ?? 'all';
$jalur    = $_GET['jalur'] ?? 'all';
$jenjang  = $_GET['jenjang'] ?? 'all';
$jenis_kelamin = $_GET['jenis_kelamin'] ?? "";

// --- Build WHERE ---
// --- Build WHERE (diperbaiki urutannya) ---
$where = [];
if ($fakultas != 'all') $where[] = "m.fakultas_id = '$fakultas'";
if ($prodi != 'all')    $where[] = "m.program_studi_id = '$prodi'";
if ($jalur != 'all')    $where[] = "m.jalur_masuk_id = '$jalur'";
if ($jenjang != 'all')  $where[] = "m.jenjang_id = '$jenjang'";
if (!empty($jenis_kelamin)) $where[] = "m.jenis_kelamin = '$jenis_kelamin'"; // ← DIPINDAHKAN ke atas sebelum $where_sql

$where_sql = $where ? "WHERE " . implode(" AND ", $where) : "";

// --- Ambil rentang tahun angkatan dari data yang ada ---
$range_query = mysqli_query($conn, "SELECT MIN(angkatan) AS min_tahun, MAX(angkatan) AS max_tahun FROM mahasiswa");
$range_data = mysqli_fetch_assoc($range_query);

if (!$range_data['min_tahun'] || !$range_data['max_tahun']) {
    $tahun_mulai = date('Y');
    $tahun_selesai = date('Y');
} else {
    $tahun_mulai = (int)$range_data['min_tahun'];
    $tahun_selesai = (int)$range_data['max_tahun'];
}

$tahun_range = range($tahun_mulai, $tahun_selesai);


// kondisi tahun
$tahun_condition = "m.angkatan BETWEEN $tahun_mulai AND $tahun_selesai";

// gabungkan kondisi filter + tahun
if ($where_sql) {
    $final_where = "$where_sql AND $tahun_condition";
} else {
    $final_where = "WHERE $tahun_condition";
}

// total mahasiswa keseluruhan sesuai filter
$total_query = mysqli_query($conn, "SELECT COUNT(*) as total FROM mahasiswa m $final_where");
$total = mysqli_fetch_assoc($total_query)['total'];

// ======================================================
// 📊 Ambil data total mahasiswa per tahun (tanpa gender)
// ======================================================
$statistik_query = mysqli_query($conn, "
    SELECT angkatan AS tahun, COUNT(*) AS total_mahasiswa
    FROM mahasiswa m
    $final_where
    GROUP BY angkatan
    ORDER BY angkatan ASC
");

// masukkan hasil query ke array
$data = [];
while ($row = mysqli_fetch_assoc($statistik_query)) {
    $data[$row['tahun']] = $row['total_mahasiswa'];
}

// isi semua tahun dengan default 0 kalau tidak ada data
$tahun = [];
$total_mahasiswa = [];
foreach ($tahun_range as $th) {
    $tahun[] = $th;
    $total_mahasiswa[] = $data[$th] ?? 0;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Statistik Mahasiswa</title>
    <link rel="icon" type="image/png" href="assets/L-o-g-o_U-P-R_s-t-a-t-u-t-a_2-0-1-7_Per-men-ris-tek-dik-ti42-2-0-1-7_j_t_s-RevOk240x240.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body class="bg-gray-100 font-sans">
<div class="flex min-h-screen">

<!-- SIDEBAR -->
<aside class="w-64 bg-blue-700 text-white flex flex-col justify-between shadow-lg">
    <div>
        <div class="p-6 border-b border-green-600 flex items-center justify-center gap-3">
            <img src="assets/L-o-g-o_U-P-R_s-t-a-t-u-t-a_2-0-1-7_Per-men-ris-tek-dik-ti42-2-0-1-7_j_t_s-RevOk240x240.png" alt="Logo UPR" class="w-12 h-12 rounded-full">
            <div>
                <h2 class="text-lg font-bold tracking-wide">SIMABA</h2>
                <p class="text-xs text-green-200">Universitas Palangka Raya</p>
            </div>
        </div>
        <nav class="mt-6 px-4">
            <ul class="space-y-2 font-medium">
                <!-- Dashboard -->
                <li>
                    <a href="index.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                    </svg>
                        Dashboard
                    </a>
                </li>
                <!-- Statistik -->
                <li>
                    <a href="statistik.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'statistik.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 0 1 3 19.875v-6.75ZM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V8.625ZM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V4.125Z" />
                    </svg>
                        Statistik
                    </a>
                </li>

                <!-- Data Mahasiswa -->
                <li>
                    <a href="data_mahasiswa.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'data_mahasiswa.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 0 1-1.125-1.125M3.375 19.5h7.5c.621 0 1.125-.504 1.125-1.125m-9.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-7.5A1.125 1.125 0 0 1 12 18.375m9.75-12.75c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125m19.5 0v1.5c0 .621-.504 1.125-1.125 1.125M2.25 5.625v1.5c0 .621.504 1.125 1.125 1.125m0 0h17.25m-17.25 0h7.5c.621 0 1.125.504 1.125 1.125M3.375 8.25c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m17.25-3.75h-7.5c-.621 0-1.125.504-1.125 1.125m8.625-1.125c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M12 10.875v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125M13.125 12h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125M20.625 12c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5M12 14.625v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 14.625c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m0 1.5v-1.5m0 0c0-.621.504-1.125 1.125-1.125m0 0h7.5" />
                    </svg>
                        Data Mahasiswa
                    </a>
                </li>

                <!-- Helpdesk -->
                 <?php if ($user_login['role'] === 'admin'): ?>
                <li>
                    <a href="helpdesk_list.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'helpdesk_list.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126ZM12 15.75h.007v.008H12v-.008Z" />
                    </svg>

                        Helpdesk
                    </a>
                </li>
                <?php endif; ?>

                <!-- Data Pengguna (hanya admin) -->
                <?php if ($user_login['role'] === 'admin'): ?>
                <li>
                    <a href="data_user.php" 
                       class="flex items-center gap-3 px-3 py-2 rounded-lg transition
                       <?php echo basename($_SERVER['PHP_SELF']) == 'data_user.php' ? 'bg-blue-600 font-semibold' : 'hover:bg-blue-600'; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                    </svg>
                        Data Pengguna
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>

<!-- PROFIL PENGGUNA (Sidebar bawah, versi rapi & konsisten) -->
<div class="relative p-4 border-t border-blue-700" x-data="{ open: false }">
    <!-- Tombol nama pengguna -->
    <button @click="open = !open" 
        class="w-full flex items-center justify-between bg-blue-700 hover:bg-blue-600 px-3 py-2 rounded-lg transition">
        <div class="flex items-center gap-3">
            <div class="w-9 h-9 rounded-full bg-blue-400 flex items-center justify-center text-white font-bold text-sm">
                <?= strtoupper(substr($user_login['nama_lengkap'], 0, 1)); ?>
            </div>
            <div class="text-left">
                <p class="text-sm font-semibold text-white truncate w-28"><?= $user_login['nama_lengkap']; ?></p>
                <p class="text-xs text-blue-200 capitalize"><?= $user_login['role']; ?></p>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-blue-200 transition-transform duration-200" 
             :class="{ 'rotate-180': open }" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <!-- Dropdown -->
    <div x-show="open" 
        @click.away="open = false"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 translate-y-2"
        x-transition:enter-end="opacity-100 translate-y-0"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100 translate-y-0"
        x-transition:leave-end="opacity-0 translate-y-2"
        class="absolute left-0 bottom-16 w-full bg-blue-700 text-white rounded-lg shadow-lg border border-blue-600 overflow-hidden z-50">
        
        <ul class="text-sm divide-y divide-blue-600">
            <?php if ($user_login['role'] === 'user'): ?>
            <li>
                <a href="ubah_password.php" 
                   class="flex items-center gap-2 px-4 py-2 hover:bg-blue-600 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" 
                         stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-blue-200">
                        <path stroke-linecap="round" stroke-linejoin="round" 
                              d="M16.5 10.5V6a4.5 4.5 0 0 0-9 0v4.5M3 10.5h18v10.125A1.125 1.125 0 0 1 19.875 21H4.125A1.125 1.125 0 0 1 3 20.625V10.5Z" />
                    </svg>
                    <span>Ubah Password</span>
                </a>
            </li>
            <?php endif; ?>
            <li>
                <a href="logout.php" 
                   class="flex items-center gap-2 px-4 py-2 hover:bg-blue-600 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" 
                         stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                        <path stroke-linecap="round" stroke-linejoin="round" 
                              d="M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6A2.25 2.25 0 0 0 5.25 5.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15M9 12h12.75" />
                    </svg>
                    <span>Logout</span>
                </a>
            </li>
        </ul>
    </div>
</div>
<!-- Alpine.js -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</aside>

<!-- Main Content -->
<main class="flex-1 p-6">
    <h1 class="text-2xl font-bold mb-6">Statistik Mahasiswa</h1>

<!-- Tombol Filter -->
<button id="openFilter" 
    class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 mb-4">
    Filter Data
</button>

<!-- Modal Filter -->
<div id="filterModal" 
     class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-3xl">
    <div class="flex justify-between items-center border-b px-6 py-3 bg-blue-600 text-white rounded-t-lg">
      <h2 class="text-lg font-semibold">Filter Statistik Mahasiswa</h2>
      <button id="closeFilter" class="text-white hover:text-gray-300 text-2xl">&times;</button>
    </div>

    <form method="GET" class="p-6 space-y-4">
<!-- Grid Form -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
  <!-- Fakultas -->
  <div>
    <label class="block text-sm font-semibold mb-1">Fakultas</label>
    <select name="fakultas" id="fakultasSelect" class="p-2 rounded border w-full">
        <option value="all">Semua</option>
        <?php mysqli_data_seek($fakultas_q, 0); while($row = mysqli_fetch_assoc($fakultas_q)): ?>
            <option value="<?= $row['id'] ?>" <?= $fakultas == $row['id'] ? 'selected' : '' ?>>
                <?= $row['nama_fakultas'] ?>
            </option>
        <?php endwhile; ?>
    </select>
  </div>

  <!-- Program Studi -->
  <div>
    <label class="block text-sm font-semibold mb-1">Program Studi</label>
    <select name="prodi" id="prodiSelect" class="p-2 rounded border w-full">
        <option value="all">Semua</option>
    </select>
  </div>

  <!-- Jalur Masuk -->
  <div>
    <label class="block text-sm font-semibold mb-1">Jalur Masuk</label>
    <select name="jalur" class="p-2 rounded border w-full">
        <option value="all">Semua</option>
        <?php mysqli_data_seek($jalur_q, 0); while($row = mysqli_fetch_assoc($jalur_q)): ?>
            <option value="<?= $row['id'] ?>" <?= $jalur == $row['id'] ? 'selected' : '' ?>>
                <?= $row['nama_jalur'] ?>
            </option>
        <?php endwhile; ?>
    </select>
  </div>

  <!-- Jenjang -->
  <div>
    <label class="block text-sm font-semibold mb-1">Jenjang</label>
    <select name="jenjang" class="p-2 rounded border w-full">
        <option value="all">Semua</option>
        <?php mysqli_data_seek($jenjang_q, 0); while($row = mysqli_fetch_assoc($jenjang_q)): ?>
            <option value="<?= $row['id'] ?>" <?= $jenjang == $row['id'] ? 'selected' : '' ?>>
                <?= $row['nama_jenjang'] ?>
            </option>
        <?php endwhile; ?>
    </select>
  </div>

  <!-- Jenis Kelamin -->
  <div>
    <label class="block text-sm font-semibold mb-1">Jenis Kelamin</label>
    <select name="jenis_kelamin" class="p-2 rounded border w-full">
        <option value="">Semua</option>
        <option value="L" <?= $jenis_kelamin == 'L' ? 'selected' : '' ?>>Laki-laki</option>
        <option value="P" <?= $jenis_kelamin == 'P' ? 'selected' : '' ?>>Perempuan</option>
    </select>
  </div>
</div>


      <!-- Tombol Aksi -->
      <div class="flex justify-end space-x-3 pt-4 border-t">
        <button type="submit" 
            class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
            Terapkan Filter
        </button>
      </div>
    </form>
  </div>
</div>

    <!-- Card Total -->
    <div class="bg-white p-4 rounded-lg shadow text-center mb-6">
        <h3 class="text-gray-700 font-semibold">Total Mahasiswa</h3>
        <p class="text-2xl font-bold text-blue-700"><?= $total; ?></p>
    </div>

<!-- Chart Bar -->
<div class="bg-white shadow rounded-lg p-6">
    <h3 class="font-semibold mb-4">
        Jumlah Mahasiswa per Tahun (<?= $tahun_mulai; ?> - <?= $tahun_selesai; ?>)
    </h3>
    <div class="mx-auto h-80">
        <canvas id="genderChart"></canvas>
    </div>
</div>

</main>
</div>

<script>
$(document).ready(function(){
    function loadProdi(fakultasId, selectedProdi) {
        $.get("statistik.php", { ajax:"getProdi", fakultas: fakultasId, selectedProdi: selectedProdi }, function(data){
            $("#prodiSelect").html('<option value="all">Semua</option>' + data);
        });
    }

    loadProdi($("#fakultasSelect").val(), "<?= $prodi ?>");

    $("#fakultasSelect").change(function(){
        loadProdi($(this).val(), "all");
    });
});

// Buka & Tutup Modal Filter
$("#openFilter").click(function() {
    $("#filterModal").removeClass("hidden");
});

$("#closeFilter, #closeFilter2").click(function() {
    $("#filterModal").addClass("hidden");
});

const canvas = document.getElementById('genderChart');
if (canvas) {
    const ctx = canvas.getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?= json_encode($tahun); ?>,
            datasets: [{
                label: 'Total Mahasiswa',
                data: <?= json_encode($total_mahasiswa); ?>,
                backgroundColor: '#3B82F6',
                borderColor: '#1E40AF',
                borderWidth: 1,
                borderRadius: 6,
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: { 
                y: { 
                    beginAtZero: true,
                    ticks: {
                        precision: 0,
                        callback: function(value) {
                            return Number.isInteger(value) ? value : null;
                        }
                    },
                    title: { display: true, text: 'Jumlah Mahasiswa', font: { weight: 'bold' } }
                },
                x: { 
                    title: { display: true, text: 'Tahun Angkatan', font: { weight: 'bold' } }
                }
            },
            plugins: {
                legend: { display: true, position: 'bottom' },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return `Total: ${context.formattedValue}`;
                        }
                    }
                }
            }
        }
    });
}
</script>
</body>
</html>
